<%@ Page Title="" Language="C#" MasterPageFile="~/Custom/BPR/BPR.Master" AutoEventWireup="true" Inherits="VIRP_WEB.Custom.BPR.QuestionTool.ToolQuestionEdit" Codebehind="ToolQuestionEdit.aspx.cs" %>
<%@ Register src="~/Controls/Custom/BPR/BaseControlCheckBox.ascx" tagname="BaseControlCheckBox" tagprefix="UserControl" %>
<%@ Register src="~/Controls/Custom/BPR/BaseControlTextBox.ascx" tagname="BaseControlTextBox" tagprefix="UserControl" %>
<%@ Register src="~/Controls/Custom/BPR/BaseControlRadioButtonListTextValue.ascx" tagname="BaseControlRadioButtonList" tagprefix="UserControl" %>
<%@ Register src="~/Controls/Custom/BPR/UserControlToolQuestionPreview.ascx" tagname="UserControlToolQuestionPreview" tagprefix="UserControl" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">

</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
<script type = "text/javascript">
    $(document).ready(function() {
        $(".minMaxValues").hide();
        if ($('#<%= BaseControlRadioButtonListTextValueQuestionType.ClientID + "_RadioButtonListID_3" %>').is(':checked')) {
            $(".minMaxValues").show();
        }
        else {
            $(".minMaxValues").hide();
        }

        $('#<%= BaseControlRadioButtonListTextValueQuestionType.ClientID + "_RadioButtonListID_0" %>').click(function() {
            $(".minMaxValues").hide();
        });

        $('#<%= BaseControlRadioButtonListTextValueQuestionType.ClientID + "_RadioButtonListID_1" %>').click(function() {
            $(".minMaxValues").hide();
        });

        $('#<%= BaseControlRadioButtonListTextValueQuestionType.ClientID + "_RadioButtonListID_2" %>').click(function() {
            $(".minMaxValues").hide();
        });

        $('#<%= BaseControlRadioButtonListTextValueQuestionType.ClientID + "_RadioButtonListID_3" %>').click(function() {
            $(".minMaxValues").show();
        });

    });
</script>
     <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Follow-up Question Tool >  Edit Question"/>
    </div> 
       <asp:LinkButton ID="HyperLinkQuestionList" runat="server" PostBackUrl="ToolQuestionList.aspx" Text="Go to Question List" />
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:HyperLink ID="HyperLinkAddQuestion" runat="server" NavigateUrl="ToolQuestionEdit.aspx?id=0" >Add New Question</asp:HyperLink>
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:LinkButton ID="LinkButtonQuestionGroupList" runat="server" PostBackUrl="ToolQuestionGroupList.aspx" Text="Go to Question Group List" />
    <br /><br />
    <asp:Panel ID="PanelEditQuestion" runat="server" GroupingText="Manage Question&nbsp;&nbsp;" Width="100%">
    <table>
        <tr>
        <td colspan="3"><UserControl:BaseControlTextBox ID="BaseControlTextboxQuestionText" runat="server" /></td>
        </tr>
        <tr>
        <td colspan="3"><UserControl:BaseControlTextBox ID="BaseControlTextboxQuestionKeyWords" runat="server" /></td>
        </tr>
        <tr>
        <td colspan="3"><UserControl:BaseControlRadioButtonList ID="BaseControlRadioButtonListTextValueQuestionType" runat="server" /></td>
        </tr>
        <tr class="minMaxValues">
            <td><UserControl:BaseControlTextBox ID="BaseControlTextBoxMinValue" runat="server" /></td>
            <td>&nbsp&nbsp&nbsp&nbsp</td>
            <td><UserControl:BaseControlTextBox ID="BaseControlTextBoxMaxValue" runat="server" /></td>
        </tr>
        <tr>
        <td colspan="3">
           <asp:Button ID="ButtonSaveQuestion" runat="server" 
                Text="Save Question" ValidationGroup="SaveQuestion" 
                onclick="ButtonSaveQuestion_Click" />
            &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
             <asp:Button ID="ButtonSubmitQuestion" runat="server" 
                Text="Submit Question" ValidationGroup="SubmitQuestion" 
                OnClientClick="return confirm('No more updates will be allowed after submitting.  Click Cancel if you are not ready to submit.');"
                onclick="ButtonSubmitQuestion_Click" /> &nbsp&nbsp&nbsp&nbsp   
                <asp:CustomValidator ID="CustomValidatorSubmitQuestion" runat="server" 
                    ErrorMessage="There are some issues in the question."
                    ValidationGroup="SubmitQuestion" ForeColor="Red"></asp:CustomValidator>   
        </td>
        </tr>

    </table>
    </asp:Panel>  
    <asp:Panel ID="PanelEditAnswer" runat="server" GroupingText="Manage Answers&nbsp;&nbsp;" Width="100%">
    <asp:Button ID="ButtonUpdateOrder" runat="server"
    Text="Update Answer Order" ToolTip='Update the order for the answers' OnClick="ButtonUpdateOrder_Click"/>
     &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
    <asp:CheckBox ID="CheckBoxDoNotWishToAnswer" runat="server" Text="I do not wish to answer" AutoPostBack="true" OnCheckedChanged="CheckBoxDoNotWishToAnswer_CheckedChanged" />
        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
    <asp:CheckBox ID="CheckBoxDoNotKnow" runat="server" Text="Don't know" AutoPostBack="true" OnCheckedChanged="CheckBoxDoNotKnow_CheckedChanged" />

     <asp:GridView ID = "GridViewAnswers"  
        ShowFooter = "True" 
        AutoGenerateColumns = "False" 
        runat ="server"   
        OnPreRender="GridViewAnswers_PreRender"
        DataKeyNames = "TOOL_ANSWER_ID" 
        OnRowCommand="GridViewAnswers_RowCommand" 
        Caption="Answers" 
        AllowPaging="False"
        AllowSorting="False" EmptyDataText="No Answers Available">
        <EmptyDataTemplate>
            <table width="100%">
                <tr>
                    <td>
                       <asp:Label ID = "LabelForTextBoxAnswerTextEmpty" Text = "Answer Text **" SkinID="DataLabel"
                            runat = "server" AssociatedControlID="TextBoxAnswerTextEmpty"  Font-Size="X-Small"></asp:Label> 
                            <br />   
                             <asp:TextBox ID="TextBoxAnswerTextEmpty" runat="server" ToolTip="Enter answer text" Width="500">
                            </asp:TextBox>
                        <br />
                        <asp:RequiredFieldValidator ID="TextBoxAnswerTextEmptyRequiredValidator" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="TextBoxAnswerTextEmpty"                                                                 
                            InitialValue=""
                            ValidationGroup = "SaveAnswer"
                            ErrorMessage="Answer Text is required.">
                        </asp:RequiredFieldValidator> 
                    </td>
                    <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                    <td>
                       <asp:Label ID = "LabelForTextBoxOrderEmpty" Text = "Order **" SkinID="DataLabel"
                            runat = "server" AssociatedControlID="TextBoxOrderEmpty"  Font-Size="X-Small"></asp:Label> 
                            <br />   
                             <asp:TextBox ID="TextBoxOrderEmpty" runat="server" ToolTip="Enter answer text" MaxLength="3" Width="50" Text="1">
                            </asp:TextBox>
                        <br />
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorTextBoxOrderEmpty" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="TextBoxOrderEmpty"                                                                 
                            InitialValue=""
                            ValidationGroup = "SaveAnswer"
                            ErrorMessage="Order is required.">
                        </asp:RequiredFieldValidator> 
                        <asp:RegularExpressionValidator ID="RegularExpressionValidatorTextBoxOrderEmpty" runat="server" 
                            ErrorMessage="Order must be a numeric value."  ControlToValidate="TextBoxOrderEmpty"  
                            ValidationExpression="^[0-9]+$" ValidationGroup = "SaveAnswer" />
                    </td>
                    <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                    <td>
                        <br />  
                        <asp:CheckBox ID="CheckBoxEditableEmpty" runat="server" Text="Editable"
                            ToolTip="Check if the answer is editable.  Otherwise, uncheck."  />
                    </td>
                    <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                    <td>
                    <asp:Label ID = "LabelForTextboxAnswerHelpEmpty" Text = "Answer Help Text" SkinID="DataLabel"
                    runat = "server" AssociatedControlID="TextboxAnswerHelpEmpty"  Font-Size="X-Small"></asp:Label> 
                    <br />   
                    <asp:Textbox ID="TextboxAnswerHelpEmpty" runat="server"  MaxLength="1000" Width="200"
                        ToolTip="Enter Help Text only when the answer is editable">
                    </asp:Textbox>
                   </td>
                    <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                    <td>
                        <br />  
                        <asp:CheckBox ID="CheckBoxClinicalRelevantEmpty" runat="server" Text="Clinically Relevant"
                            ToolTip="Check if the answer is clinically relevant.  Otherwise, uncheck."  />
                    </td>
                    <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                      <td>
                        <br />
                        <asp:Button ID="ButtonEmptyAddCommand" runat="server" 
                            Text="  Add  " 
                            ToolTip="Add Answer" 
                            CommandName="EMPTYADD" 
                            CausesValidation="true" ValidationGroup = "SaveAnswer" />
                    </td>
                </tr>
            </table>
             
        </EmptyDataTemplate>
        <Columns>
          <asp:TemplateField HeaderText = "Answer Text">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID = "LabelAnswerText" runat = "server" SkinID="DataLabel" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("TEXT")) %>'/>
                </ItemTemplate>
                <FooterTemplate>                                                                      
                    <asp:Label ID = "LabelForTextBoxAnswerText" Text = "Answer Text **" SkinID="DataLabel"
                    runat = "server" AssociatedControlID="TextBoxAnswerText"  Font-Size="X-Small"></asp:Label> 
                    <br />   
                     <asp:TextBox ID="TextBoxAnswerText" runat="server" ToolTip="Enter answer text" Width="500">
                    </asp:TextBox>
                <br />
                <asp:RequiredFieldValidator ID="TextBoxAnswerTextRequiredValidator" runat="server" 
                    ForeColor="Red" 
                    Display="Dynamic" 
                    EnableClientScript="true"  
                    SetFocusOnError="true"                                                            
                    ControlToValidate="TextBoxAnswerText"                                                                 
                    InitialValue=""
                    ValidationGroup = "SaveAnswer"
                    ErrorMessage="Answer Text is required.">
                </asp:RequiredFieldValidator> 
               </FooterTemplate> 
           </asp:TemplateField>
            <asp:TemplateField HeaderText = "Order">
                <ItemStyle HorizontalAlign="Center" />
                <FooterStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                        <asp:Label ID="LabelforTextBoxOrder" runat="server" Text="Order"  
                                AssociatedControlID="TextBoxOrder" CssClass="visuallyhidden" />
                    <asp:TextBox ID="TextBoxOrder" runat="server" ToolTip="Enter answer order" MaxLength="3" Width="50"
                        Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("ORDER")) %>'>
                    </asp:TextBox>
                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorTextBoxOrder" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="TextBoxOrder"                                                                 
                            InitialValue=""
                            ValidationGroup = "SaveAnswer"
                            ErrorMessage="Order is required.">
                    </asp:RequiredFieldValidator> 
                    <asp:RegularExpressionValidator ID="RegularExpressionValidatorTextBoxOrder" runat="server" 
                            ErrorMessage="Order must be a numeric value."  ControlToValidate="TextBoxOrder"  
                            ValidationExpression="^[0-9]+$" ValidationGroup = "SaveAnswer" />
                </ItemTemplate>
                <FooterTemplate>
                       <asp:Label ID = "LabelForTextBoxOrder" Text = "Order **" SkinID="DataLabel" Width="50"
                            runat = "server" AssociatedControlID="TextBoxOrder"  Font-Size="X-Small"></asp:Label> 
                            <br />   
                             <asp:TextBox ID="TextBoxOrder" runat="server" ToolTip="Enter answer order" MaxLength="3" Width="50">
                            </asp:TextBox>
                        <br />
                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorTextBoxOrder" runat="server" 
                            ForeColor="Red" 
                            Display="Dynamic" 
                            EnableClientScript="true"  
                            SetFocusOnError="true"                                                            
                            ControlToValidate="TextBoxOrder"                                                                 
                            InitialValue=""
                            ValidationGroup = "SaveAnswer"
                            ErrorMessage="Order is required.">
                        </asp:RequiredFieldValidator> 
                        <asp:RegularExpressionValidator ID="RegularExpressionValidatorTextBoxOrder" runat="server" 
                            ErrorMessage="Order must be a numeric value."  ControlToValidate="TextBoxOrder"  
                            ValidationExpression="^[0-9]+$" ValidationGroup = "SaveAnswer" />
              </FooterTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText = "Editable" >
               <HeaderStyle HorizontalAlign="Center" />
               <ItemTemplate>
                    <asp:Label ID = "LabelEditable" runat = "server" SkinID="DataLabel" Text = '<%# Convert.ToBoolean(Eval("EDITABLE")) ? "Yes" : "No" %>'/>
                </ItemTemplate>
                <FooterTemplate>
                <br />  
                <asp:CheckBox ID="CheckBoxEditable" runat="server" Text="Editable"
                    ToolTip="Check if the answer is editable.  Otherwise, uncheck."  />
                </FooterTemplate> 
             </asp:TemplateField>
             <asp:TemplateField HeaderText = "Answer Help Text">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID = "LabelAnswerHelp" runat = "server" SkinID="DataLabel" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("HELP")) %>'/>
                </ItemTemplate>
                <FooterTemplate>                                                                     
                    <asp:Label ID = "LabelForTextboxAnswerHelp" Text = "Answer Help Text" SkinID="DataLabel" Width="200"
                    runat = "server" AssociatedControlID="TextboxAnswerHelp"  Font-Size="X-Small"></asp:Label> 
                    <br />   
                    <asp:Textbox ID="TextboxAnswerHelp" runat="server"  MaxLength="1000"
                        ToolTip="Enter Help Text only when the answer is editable">
                    </asp:Textbox>
               </FooterTemplate> 
            </asp:TemplateField>
            <asp:TemplateField HeaderText = "Clinically Relevant">
                <ItemStyle HorizontalAlign="Center" />
                <FooterStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID = "LabelClinicalRelevant" runat = "server" SkinID="DataLabel" Text = '<%# Convert.ToBoolean(Eval("CLINICAL_RELEVANT_FLAG")) ? "Yes" : "No" %>'/>
                </ItemTemplate>
                <FooterTemplate>
                    <br />  
                    <asp:CheckBox ID="CheckBoxClinicalRelevant" runat="server" Text="Clinically Relevant"
                        ToolTip="Check if the answer is clinically relevant.  Otherwise, uncheck."  />
              </FooterTemplate>
            </asp:TemplateField>
            <asp:TemplateField >
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle HorizontalAlign="Center" />
                <FooterStyle HorizontalAlign="Center" />
                <ItemTemplate>
                   <asp:Button ID="ButtonDelete" runat="server"
                        Text="  Delete  "
                        OnClientClick="return confirm('Are you sure you want to delete this answer? Click cancel if you do not want to delete.');"
                        ToolTip='<%# string.Format("Delete {0} from Answer list", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"TEXT")))) %>' 
                        CommandName="DELETE_FLAG" 
                        CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TOOL_ANSWER_ID"))) %>' 
                        CausesValidation="false"/>
                </ItemTemplate>
                <FooterTemplate>
                   <br />
                   <asp:Button Text="  Add  " ToolTip="Add Answer" CommandName="ADD" CausesValidation="true" runat="server" ID="ButtonAddCommand" 
                   ValidationGroup = "SaveAnswer"  />&nbsp;
                </FooterTemplate>
            </asp:TemplateField>
           <asp:TemplateField HeaderText = "Answer ID" Visible="false">
                <ItemTemplate>
                    <asp:Label ID = "LabelAnswerID" runat = "server" SkinID="DataLabel" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("TOOL_ANSWER_ID")) %>'/>
                </ItemTemplate>
           </asp:TemplateField>
       </Columns>
    </asp:GridView>
    <asp:Label runat="server" ID="LabelFootNote" Text="** indicates required field" CssClass="foot-note" SkinID="DataLabel" ></asp:Label>
   </asp:Panel>  
    <br />
   <asp:Panel ID="PanelPreview" runat="server" GroupingText="Preview Question and Answers&nbsp;&nbsp;" Width="100%">
   <UserControl:UserControlToolQuestionPreview ID="UserControlToolQuestionPreview" runat="server" />
   </asp:Panel>
   <asp:LinkButton ID="HyperLinkQuestionListBottom" runat="server" PostBackUrl="ToolQuestionList.aspx" Text="Go to Question List" />
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl="ToolQuestionEdit.aspx?id=0" >Add New Question</asp:HyperLink>
   &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
   <asp:LinkButton ID="LinkButtonQuestionGroupListBottom" runat="server" PostBackUrl="ToolQuestionGroupList.aspx" Text="Go to Question Group List" />
    <br />
    <asp:HiddenField ID="HiddenFieldQuestionId" runat="server" />
</asp:Content>

